/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.IncrementableIntegerJTextField;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.display.AIDetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplaySettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditorAllocator;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditorListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplaySelectionEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplaySelectionListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayToolTipProvider;
import DE.siemens.ad.logo.dialog.comp.display.ExtenalMoveModel;
import DE.siemens.ad.logo.dialog.comp.display.IONameDetailsDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameSettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.OnlineBarDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.OnlineIONameDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.OnlineTextCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.ParameterItemDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.RectangleElementsDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDetailDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeSettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.MessageEditorPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.udf.UDFParameterItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public class LogoDisplay
extends JComponent
implements CellEditorListener,
DisplayModelListener {
    protected DisplayCellEditor fCurrentCellEditor;
    protected Component fCurrentEditorComp;
    protected CellEditorRemover fEditorRemover;
    protected Point fEditingPosition;
    private Point fStartSelection = null;
    private Point fEndSelection = null;
    protected DisplayCellEditorAllocator fDisplayCellEditorAllocator;
    protected boolean fDynamicCellDimensionEnabled = true;
    protected Point fFocusPosition = new Point(0, 0);
    protected Dimension fCellDimension = new Dimension(0, 0);
    protected DisplayElement fDefaultInsertElement = new DefaultDisplayElement("", 1, 1);
    protected Dimension fDisplayDimension = new Dimension(1, 1);
    protected Dimension fInterCellSpacing = new Dimension(1, 1);
    protected DisplayCellRenderer fCellRenderer = new DefaultDisplayCellRenderer();
    public Rectangle fDropRectangle = null;
    protected Map fRendererMap;
    protected boolean fInsertMode = false;
    protected DisplayCellEditor fDefaultCellEditor = null;
    protected CellRendererPane fCellRendererPane;
    protected DisplayModel fModel;
    protected boolean fDragEnabled;
    protected DisplayToolTipProvider fToolTipProvider;
    private EventListenerList fEventListeners = new EventListenerList();
    public static int MODE_DETAIL = 1;
    public static int MODE_VALUE = 2;
    public static int MODE_ONLINE = 3;
    private Color fSimulationColor = Global.LOGO_DISPLAY_COLOR;
    boolean fSimulationMode = false;
    boolean fOnlineTestMode = false;
    boolean fProtectionMode = false;

    private boolean isBiWidthCharacterset() {
        if (this.fModel instanceof MutiCharSetDisplayModel) {
            return ((MutiCharSetDisplayModel)((Object)this.fModel)).isBiWidthCharacterset();
        }
        return false;
    }

    public void moveFocusTo(Point cell, boolean extendSelection) {
        this.setFocusPosition(new Point(cell));
        if (extendSelection) {
            this.setEndSelection(new Point(cell));
        } else if (!this.fInsertMode) {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(new Point(this.fFocusPosition));
        } else {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(null);
        }
        this.repaint();
    }

    public LogoDisplay() {
        this.fModel = new RectangleElementsDisplayModel(new Dimension(1, 1));
        this.setLayout(null);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.setBackground(Color.black);
        this.setSize(this.getPreferredSize());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        DefaultDisplayCellRenderer cellRenderer = new DefaultDisplayCellRenderer();
        cellRenderer.setDefaultBackground(Color.red);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        FocusHandler focusHandler = new FocusHandler();
        this.addFocusListener(focusHandler);
        this.createActionMap();
    }

    public LogoDisplay(DisplayModel displayModel) {
        this();
        this.fModel = displayModel;
    }

    protected void createActionMap() {
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "cursorLeft");
        this.getActionMap().put("cursorLeft", new NavigationalAction(-1, 0, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "cursorRight");
        this.getActionMap().put("cursorRight", new NavigationalAction(1, 0, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "cursorUp");
        this.getActionMap().put("cursorUp", new NavigationalAction(0, -1, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "cursorDown");
        this.getActionMap().put("cursorDown", new NavigationalAction(0, 1, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 64), "cursorLeftSelect");
        this.getActionMap().put("cursorLeftSelect", new NavigationalAction(-1, 0, true));
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 64), "cursorRightSelect");
        this.getActionMap().put("cursorRightSelect", new NavigationalAction(1, 0, true));
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 64), "cursorUpSelect");
        this.getActionMap().put("cursorUpSelect", new NavigationalAction(0, -1, true));
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 64), "cursorDownSelect");
        this.getActionMap().put("cursorDownSelect", new NavigationalAction(0, 1, true));
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "tabLeft");
        this.getActionMap().put("tabLeft", new NavigationalAction(-1, 0, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "tabRight");
        this.getActionMap().put("tabRight", new NavigationalAction(1, 0, false));
        this.getInputMap().put(KeyStroke.getKeyStroke(8, 0), "backspace");
        this.getActionMap().put("backspace", new NavigationalAction("backspace"));
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", new NavigationalAction("delete"));
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getActionMap().put("escape", new NavigationalAction("escape"));
        this.getInputMap().put(KeyStroke.getKeyStroke(65, 2), "selectAll");
        this.getActionMap().put("selectAll", new NavigationalAction("selectAll"));
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
        this.getActionMap().put("copy", new NavigationalAction("copy"));
        this.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "paste");
        this.getActionMap().put("paste", new NavigationalAction("paste"));
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 0), "insert");
        this.getActionMap().put("insert", new NavigationalAction("insert"));
        this.getInputMap().put(KeyStroke.getKeyStroke(36, 0), "home");
        this.getActionMap().put("home", new NavigationalAction("home"));
        this.getInputMap().put(KeyStroke.getKeyStroke(35, 0), "end");
        this.getActionMap().put("end", new NavigationalAction("end"));
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.getActionMap().put("enter", new NavigationalAction("enter"));
    }

    public Dimension getCellDimension() {
        if (this.fDynamicCellDimensionEnabled) {
            Dimension size = new Dimension(this.getSize());
            size.width /= this.getModel().getDisplayDimension().width;
            size.height /= this.getModel().getDisplayDimension().height;
            size.width -= this.fInterCellSpacing.width;
            size.height -= this.fInterCellSpacing.height;
            return size;
        }
        return this.getDefaultCellDimesion();
    }

    protected Dimension getDefaultCellDimesion() {
        if (this.fSimulationMode || this.fOnlineTestMode) {
            return this.getSimulationCellDimension();
        }
        return this.getEditCellDimension();
    }

    protected Dimension getEditCellDimension() {
        int cell_height = 32;
        this.fCellDimension.width = this.fModel instanceof MutiCharSetDisplayModel && this.isBiWidthCharacterset() ? 14 : 19;
        this.fCellDimension.height = 31;
        return this.fCellDimension;
    }

    protected Dimension getSimulationCellDimension() {
        int cell_height = 40;
        this.fCellDimension.width = this.fModel instanceof MutiCharSetDisplayModel && this.isBiWidthCharacterset() ? 14 : 19;
        this.fCellDimension.height = 39;
        return this.fCellDimension;
    }

    protected Rectangle getCellBounds(Point location) {
        Rectangle columnRowBounds = this.fModel.getElementBounds(location);
        if (columnRowBounds == null) {
            return this.getDefaultCellBounds(location, 0, 0);
        }
        Rectangle ret = new Rectangle(columnRowBounds.x * (this.getCellDimension().width + this.fInterCellSpacing.width), columnRowBounds.y * (this.getCellDimension().height + this.fInterCellSpacing.height), columnRowBounds.width * this.getCellDimension().width + (columnRowBounds.width - 1) * this.fInterCellSpacing.width, columnRowBounds.height * this.getCellDimension().height + (columnRowBounds.height - 1) * this.fInterCellSpacing.height);
        return ret;
    }

    private Rectangle getDefaultCellBounds(Point location, int width, int height) {
        return new Rectangle(location.x * (this.getCellDimension().width + this.fInterCellSpacing.width), location.y * (this.getCellDimension().height + this.fInterCellSpacing.height), width * this.getCellDimension().width, height * this.getCellDimension().height);
    }

    public DisplayCellRenderer getDisplayCellRenderer(Point location) {
        DisplayElement displayElement = this.fModel.getElementAt(location);
        DisplayCellRenderer renderer = null;
        if (this.fRendererMap != null && displayElement != null) {
            renderer = (DisplayCellRenderer)this.fRendererMap.get(displayElement.getClass());
        }
        if (renderer == null) {
            renderer = this.fCellRenderer;
        }
        return renderer;
    }

    public DisplayCellEditor getDisplayCellEditor(Point location) {
        if (this.fOnlineTestMode) {
            return null;
        }
        DisplayElement displayElement = this.fModel.getElementAt(location);
        DisplayCellEditor editor = null;
        if (this.getDisplayCellEditorAllocator() != null && displayElement != null) {
            editor = this.getDisplayCellEditorAllocator().getDisplayCellEditor(displayElement);
        }
        if (editor == null && !(displayElement instanceof SpecialCharacterDisplayElement) && (displayElement == null || displayElement instanceof DefaultDisplayElement) && (editor = this.fDefaultCellEditor) instanceof OneCharacterCellEditor) {
            if (this.fModel instanceof MutiCharSetDisplayModel) {
                ((OneCharacterCellEditor)editor).setCharSet(((MutiCharSetDisplayModel)((Object)this.fModel)).getCharSet());
            } else {
                ((OneCharacterCellEditor)editor).setCharSet(0);
            }
        }
        return editor;
    }

    public void setDefaultCellEditor(DisplayCellEditor displayCellEditor) {
        this.fDefaultCellEditor = displayCellEditor;
    }

    public void setCellRenderer(DisplayCellRenderer displayCellRenderer) {
        this.fCellRenderer = displayCellRenderer;
    }

    protected void setCellRenderer(Class elementClass, DisplayCellRenderer displayCellRenderer) {
        this.getRendererMap().put(elementClass, displayCellRenderer);
    }

    public void setCellRendererMode(int mode) {
        if (mode == MODE_DETAIL) {
            this.setCellRenderer(UDFParameterItem.class, new DetailsParameterDisplayCellRenderer());
            this.setCellRenderer(ParameterItem.class, new DetailsParameterDisplayCellRenderer());
            this.setCellRenderer(BarDisplayElement.class, new BarDetailsParameterDisplayCellRenderer());
            this.setCellRenderer(AIDisplayElement.class, new AIDetailsParameterDisplayCellRenderer());
            this.setCellRenderer(IONameDisplayElement.class, new IONameDetailsDisplayCellRenderer());
            this.setCellRenderer(ScaleTimeDisplayElement.class, new ScaleTimeDetailDisplayCellRenderer());
        } else if (mode == MODE_VALUE) {
            this.setCellRenderer(ParameterItem.class, new ParameterItemDisplayCellRenderer());
            this.setCellRenderer(BarDisplayElement.class, new BarDisplayCellRenderer());
            this.setCellRenderer(IONameDisplayElement.class, new IONameDisplayCellRenderer());
            this.setCellRenderer(AIDisplayElement.class, new AIDisplayCellRenderer());
            this.setCellRenderer(UDFParameterItem.class, new ParameterItemDisplayCellRenderer());
            this.setCellRenderer(ScaleTimeDisplayElement.class, new ScaleTimeDisplayCellRenderer());
        } else if (mode == MODE_ONLINE) {
            this.setCellRenderer(ParameterItem.class, new OnlineTextCellRenderer());
            this.setCellRenderer(BarDisplayElement.class, new OnlineBarDisplayCellRenderer());
            this.setCellRenderer(IONameDisplayElement.class, new OnlineIONameDisplayCellRenderer());
            this.setCellRenderer(AIDisplayElement.class, new OnlineTextCellRenderer());
            this.setCellRenderer(UDFParameterItem.class, new OnlineTextCellRenderer());
            this.setCellRenderer(ScaleTimeDisplayElement.class, new OnlineTextCellRenderer());
        }
    }

    protected Map getRendererMap() {
        if (this.fRendererMap == null) {
            this.fRendererMap = new Hashtable(5);
        }
        return this.fRendererMap;
    }

    public Dimension getPreferredSize() {
        return new Dimension((this.getDefaultCellDimesion().width + this.fInterCellSpacing.width) * this.fDisplayDimension.width, (this.getDefaultCellDimesion().height + this.fInterCellSpacing.height) * this.fDisplayDimension.height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Component prepareEditor(DisplayCellEditor editor, int row, int column) {
        boolean isSelected;
        DisplayElement value = this.fModel.getElementAt(new Point(column, row));
        Component comp = editor.getDisplayCellEditorComponent(this, value, isSelected = false, row, column);
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            if (jComp.getNextFocusableComponent() == null) {
                jComp.setNextFocusableComponent(this);
            }
            jComp.registerKeyboardAction(new CancelEditAction(), KeyStroke.getKeyStroke(27, 0), 1);
            jComp.registerKeyboardAction(new StopEditAction(), KeyStroke.getKeyStroke(10, 0), 1);
        }
        return comp;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBarOrNot(g, false);
        this.paintBarOrNot(g, true);
    }

    public boolean setSimulationColor(Color newColor) {
        if (newColor != null && this.fSimulationColor != newColor) {
            this.fSimulationColor = newColor;
            return true;
        }
        return false;
    }

    public Color getSimulationColor() {
        return this.fSimulationColor;
    }

    private void paintBarOrNot(Graphics g, boolean paintBar) {
        Rectangle visibleRect = g.getClipBounds();
        Point upperLeftCell = this.convertPointToCell(visibleRect.getLocation());
        Point lowerRightCell = this.convertPointToCell(new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height));
        upperLeftCell.x = Math.max(upperLeftCell.x, 0);
        upperLeftCell.y = Math.max(upperLeftCell.y, 0);
        lowerRightCell.x = Math.min(lowerRightCell.x, this.fModel.getDisplayDimension().width - 1);
        lowerRightCell.y = Math.min(lowerRightCell.y, this.fModel.getDisplayDimension().height - 1);
        for (int y = upperLeftCell.y; y <= lowerRightCell.y; ++y) {
            int x = upperLeftCell.x;
            while (x < this.fModel.getDisplayDimension().width) {
                Point currentCell = new Point(x, y);
                Rectangle cellBounds = this.fModel.getElementBounds(currentCell);
                if (cellBounds.contains(currentCell)) {
                    Rectangle cellArea = this.fModel.getElementBounds(currentCell);
                    boolean hasFocus = cellArea.contains(this.fFocusPosition);
                    DisplayElement value = this.fModel.getElementAt(currentCell);
                    if (paintBar && (!(value instanceof BarDisplayElement) || cellBounds.y != currentCell.y)) {
                        ++x;
                        continue;
                    }
                    DisplayCellRenderer cellRender = null;
                    Rectangle cellDisplayBounds = null;
                    if (value instanceof BarDisplayElement && !paintBar) {
                        value = null;
                        cellRender = this.fCellRenderer;
                        cellDisplayBounds = this.getDefaultCellBounds(currentCell, 1, 1);
                        cellBounds = new Rectangle(currentCell.x, currentCell.y, 1, 1);
                    } else {
                        cellRender = this.getDisplayCellRenderer(currentCell);
                        cellDisplayBounds = this.getCellBounds(currentCell);
                    }
                    if ((this.fSimulationMode || this.fOnlineTestMode) && cellRender instanceof DefaultDisplayCellRenderer) {
                        ((DefaultDisplayCellRenderer)cellRender).setDefaultBackground(this.fSimulationColor);
                    }
                    Component cellRendererComponent = cellRender.getDisplayCellRendererComponent(this, value, this.isCellSelected(currentCell), hasFocus, cellBounds.y, cellBounds.x);
                    this.getCellRendererPane().paintComponent(g, cellRendererComponent, this, cellDisplayBounds.x, cellDisplayBounds.y, cellDisplayBounds.width, cellDisplayBounds.height, true);
                }
                if (cellBounds.width > 0 && cellBounds.y == currentCell.y) {
                    x = cellBounds.x + cellBounds.width;
                    continue;
                }
                ++x;
            }
        }
        if (this.fDropRectangle != null) {
            g.setColor(Color.black);
            Rectangle r = new Rectangle(this.convertCellToPoint(this.fDropRectangle.getLocation()), this.convertCellDimensionToDisplayDimension(this.fDropRectangle.getSize()));
            g.drawRect(r.x, r.y, r.width - this.fInterCellSpacing.width - 1, r.height - this.fInterCellSpacing.height - 1);
            g.drawRect(r.x + 1, r.y + 1, r.width - this.fInterCellSpacing.width - 3, r.height - this.fInterCellSpacing.height - 3);
        }
    }

    private CellRendererPane getCellRendererPane() {
        if (this.fCellRendererPane == null) {
            this.fCellRendererPane = new CellRendererPane();
            this.add(this.fCellRendererPane);
        }
        return this.fCellRendererPane;
    }

    public boolean isEditing() {
        return this.fCurrentCellEditor != null;
    }

    public DisplayElement getFocusedElement() {
        if (this.fFocusPosition != null) {
            return this.fModel.getElementAt(this.fFocusPosition);
        }
        return null;
    }

    public void deleteCells(List cells) {
        this.getModel().deleteCells(cells);
        this.clearSelection();
    }

    public boolean isCellSelected(Point location) {
        if (this.getStartSelection() == null || this.getEndSelection() == null) {
            return false;
        }
        if (this.fModel instanceof RectangleElementsDisplayModel) {
            ArrayList<Point> startEndPoints = new ArrayList<Point>();
            startEndPoints.add(this.getStartSelection());
            startEndPoints.add(this.getEndSelection());
            Rectangle selectedRectangle = ((RectangleElementsDisplayModel)this.fModel).getSelectedRectangle(startEndPoints);
            return selectedRectangle.contains(location);
        }
        Rectangle selectedArea = new Rectangle(Math.min(this.getStartSelection().x, this.getEndSelection().x), Math.min(this.getStartSelection().y, this.getEndSelection().y), Math.abs(this.getEndSelection().x - this.getStartSelection().x) + 1, Math.abs(this.getEndSelection().y - this.getStartSelection().y) + 1);
        Rectangle elementArea = this.fModel.getElementBounds(location);
        return selectedArea.intersects(elementArea);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean editCellAt(int row, int column, EventObject e) {
        DisplayCellEditor editor;
        if (this.isEditing() && !this.fCurrentCellEditor.stopCellEditing()) {
            return false;
        }
        if (this.fProtectionMode && (this.fSimulationMode || this.fOnlineTestMode)) {
            return false;
        }
        Point editedCellLocation = new Point(column, row);
        DisplayElement disp = this.fModel.getElementAt(editedCellLocation);
        Rectangle editorBount = this.getCellBounds(editedCellLocation);
        if (disp instanceof ParameterItem && (this.fSimulationMode || this.fOnlineTestMode)) {
            if (column + disp.getWidth() <= 0 || row >= this.fDisplayDimension.width) return false;
            if (this.isBiWidthCharacterset()) {
                editorBount.width = editorBount.width * 4 / 3;
            }
            int minWidth = 122;
            if (editorBount.width < 122) {
                editorBount.width = 122;
            }
            if (editorBount.x < 0) {
                editorBount.x = 0;
            } else if (editorBount.x + editorBount.width > this.getSize().width) {
                editorBount.x = this.getSize().width - editorBount.width - 1;
            }
        } else if (row < 0 || row >= this.fDisplayDimension.height || column < 0 || column >= this.fDisplayDimension.width) {
            return false;
        }
        if (!this.fModel.isCellEditable(editedCellLocation)) {
            return false;
        }
        if (this.fEditorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.fEditorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.fEditorRemover);
        }
        if ((editor = this.getDisplayCellEditor(editedCellLocation)) == null || !editor.isCellEditable(e)) return false;
        this.fCurrentEditorComp = this.prepareEditor(editor, row, column);
        if (this.fCurrentEditorComp == null) {
            this.removeEditor();
            return false;
        }
        this.fCurrentEditorComp.setBounds(editorBount);
        this.add(this.fCurrentEditorComp);
        this.fCurrentEditorComp.setVisible(true);
        this.fCurrentEditorComp.requestFocus();
        this.fCurrentEditorComp.validate();
        this.fCurrentEditorComp.repaint();
        this.fCurrentCellEditor = editor;
        this.fEditingPosition = new Point(column, row);
        editor.addCellEditorListener(this);
        this.fireCellEditingStartedEvent();
        return true;
    }

    private Rectangle getEnclosingRectangle(List cells) {
        if (cells == null || cells.isEmpty()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle enclosingRectangle = null;
        for (Point cell : cells) {
            Rectangle cellBounds = this.fModel.getElementBounds(cell);
            if (enclosingRectangle == null) {
                enclosingRectangle = cellBounds;
                continue;
            }
            enclosingRectangle = enclosingRectangle.union(cellBounds);
        }
        return enclosingRectangle;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.fEditorRemover);
        this.fEditorRemover = null;
        if (this.fCurrentCellEditor != null) {
            this.fCurrentCellEditor.removeCellEditorListener(this);
            if (this.fCurrentEditorComp != null) {
                this.fCurrentEditorComp.setVisible(false);
                this.requestFocus();
            }
            Rectangle cellRect = this.getCellBounds(this.fEditingPosition);
            this.fCurrentCellEditor = null;
            this.fEditingPosition = null;
            this.fCurrentEditorComp = null;
            this.repaint(cellRect);
            this.validate();
        }
    }

    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
        this.fireCellEditingCanclledEvent();
    }

    public void editingStopped(ChangeEvent e) {
        DisplayCellEditor editor = this.fCurrentCellEditor;
        if (editor != null) {
            DisplayElement value = (DisplayElement)editor.getCellEditorValue();
            if (!(this.fModel.setElementAt(value, this.fEditingPosition) || this.fSimulationMode || this.fOnlineTestMode)) {
                this.showManualEditPanel(false, null, value, null);
            }
            this.removeEditor();
        }
        this.fireCellEditingStoppedEvent();
    }

    public Point convertPointToCell(Point pixelLocation) {
        Dimension cellDimension = this.getCellDimension();
        return new Point(pixelLocation.x / (cellDimension.width + this.fInterCellSpacing.width), pixelLocation.y / (cellDimension.height + this.fInterCellSpacing.height));
    }

    protected Point convertCellToPoint(Point cellLocation) {
        Dimension cellDimension = this.getCellDimension();
        return new Point(cellLocation.x * (cellDimension.width + this.fInterCellSpacing.width), cellLocation.y * (cellDimension.height + this.fInterCellSpacing.height));
    }

    public void addDisplaySelectionListener(DisplaySelectionListener displaySelectionListener) {
        this.fEventListeners.add(DisplaySelectionListener.class, displaySelectionListener);
    }

    public void removeDisplaySelectionListener(DisplaySelectionListener displaySelectionListener) {
        this.fEventListeners.remove(DisplaySelectionListener.class, displaySelectionListener);
    }

    protected Dimension convertCellDimensionToDisplayDimension(Dimension modelCellDimension) {
        Dimension cellDimension = this.getCellDimension();
        return new Dimension(modelCellDimension.width * (cellDimension.width + this.fInterCellSpacing.width), modelCellDimension.height * (cellDimension.height + this.fInterCellSpacing.height));
    }

    public void moveFocus(int dx, int dy, boolean extendSelection) {
        Point oldFocusPosition = new Point(this.fFocusPosition);
        if (this.fCurrentCellEditor != null && !this.fCurrentCellEditor.stopCellEditing()) {
            this.fCurrentCellEditor.cancelCellEditing();
        }
        Rectangle cellBounds = this.fModel.getElementBounds(this.fFocusPosition);
        if (dy == -1) {
            this.fFocusPosition.y = Math.max(cellBounds.y - 1, 0);
        }
        if (dy == 1) {
            this.fFocusPosition.y = Math.min(cellBounds.y + cellBounds.height, this.fDisplayDimension.height - 1);
        }
        if (dx == 1) {
            this.fFocusPosition.x = Math.min(cellBounds.x + cellBounds.width, this.fDisplayDimension.width - 1);
        }
        if (dx == -1) {
            this.fFocusPosition.x = Math.max(cellBounds.x - 1, 0);
        }
        this.setFocusPosition(this.fModel.getElementBounds(this.fFocusPosition).getLocation());
        if (extendSelection) {
            this.setEndSelection(new Point(this.fFocusPosition));
        } else if (!this.fInsertMode) {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(new Point(this.fFocusPosition));
        } else {
            this.setStartSelection(new Point(this.fFocusPosition));
            this.setEndSelection(null);
        }
        if (!this.fFocusPosition.equals(oldFocusPosition)) {
            this.fireFocusPositionChangedEvent(oldFocusPosition, this.fFocusPosition);
        }
        this.repaint();
    }

    public Dimension getInterCellSpacing() {
        return this.fInterCellSpacing;
    }

    public void setInterCellSpacing(Dimension interCellSpacing) {
        this.fInterCellSpacing = interCellSpacing;
    }

    public Point getFocusPosition() {
        return this.fFocusPosition;
    }

    public void setFocusPosition(Point focusPosition) {
        Point oldFocusPosition = this.fFocusPosition;
        this.fFocusPosition = focusPosition;
        if (this.fFocusPosition.x < 0) {
            this.fFocusPosition.x = 0;
        }
        if (oldFocusPosition != null && !oldFocusPosition.equals(focusPosition)) {
            this.fireFocusPositionChangedEvent(oldFocusPosition, focusPosition);
        }
    }

    private void fireFocusPositionChangedEvent(Point oldFocusPosition, Point newFocusPosition) {
        DisplayFocusEvent displayFocusEvent = new DisplayFocusEvent(this, oldFocusPosition, newFocusPosition);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayFocusListener.class) continue;
            ((DisplayFocusListener)listeners[i + 1]).displayFocusPositionChanged(displayFocusEvent);
        }
    }

    private void fireCellEditingStartedEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayCellEditorListener.class) continue;
            ((DisplayCellEditorListener)listeners[i + 1]).editingStarted(changeEvent);
        }
    }

    private void fireCellEditingStoppedEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayCellEditorListener.class) continue;
            ((DisplayCellEditorListener)listeners[i + 1]).editingStopped(changeEvent);
        }
    }

    private void fireCellEditingCanclledEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplayCellEditorListener.class) continue;
            ((DisplayCellEditorListener)listeners[i + 1]).editingCanceled(changeEvent);
        }
    }

    public Dimension getDisplayDimension() {
        return this.fDisplayDimension;
    }

    public void clearSelection() {
        this.setStartSelection(this.fFocusPosition);
        this.setEndSelection(null);
        this.repaint();
    }

    public DisplayElement getDefaultInsertElement() {
        return this.fDefaultInsertElement;
    }

    public void setDefaultInsertElement(DisplayElement defaultInsertElement) {
        this.fDefaultInsertElement = defaultInsertElement;
    }

    public DisplayModel getModel() {
        return this.fModel;
    }

    public void setModel(DisplayModel model) {
        this.clearSelection();
        this.setFocusPosition(new Point(0, 0));
        if (this.fModel != null) {
            this.fModel.removeDisplayModelListener(this);
        }
        this.fModel = model;
        if (this.fModel != null) {
            this.fDisplayDimension = this.fModel.getDisplayDimension();
            this.fModel.addDisplayModelListener(this);
        }
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void displayModelChanged(final DisplayModelEvent displayModelEvent) {
        if (displayModelEvent.getType() == 1) {
            this.setModel(this.getModel());
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    Rectangle modelArea = displayModelEvent.getArea();
                    if (modelArea != null) {
                        Rectangle displayArea = new Rectangle(LogoDisplay.this.convertCellToPoint(modelArea.getLocation()), LogoDisplay.this.convertCellDimensionToDisplayDimension(modelArea.getSize()));
                        LogoDisplay.this.repaint(displayArea);
                    } else {
                        LogoDisplay.this.repaint();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public boolean isDragEnabled() {
        return this.fDragEnabled;
    }

    public Border getFocusBorder() {
        if (this.hasFocus()) {
            return BorderFactory.createLineBorder(Color.YELLOW);
        }
        return BorderFactory.createLineBorder(Color.yellow.darker());
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.fDragEnabled = dragEnabled;
        this.setTransferHandler(new DisplayElementTransferHandler());
    }

    public void setDropEnabled(boolean dropEnabled) {
        if (dropEnabled) {
            new DropTarget(this, (DropTargetListener)new DisplayDropTarget(this)){};
        }
    }

    public List getSelectedCells() {
        ArrayList<Point> selectedCells = new ArrayList<Point>();
        boolean[][] checked = new boolean[this.fDisplayDimension.width][this.fDisplayDimension.height];
        for (int y = 0; y < this.fDisplayDimension.height; ++y) {
            int x = 0;
            while (x < this.fDisplayDimension.width) {
                if (checked[x][y]) {
                    ++x;
                    continue;
                }
                Point currentCell = new Point(x, y);
                Rectangle cellBounds = this.fModel.getElementBounds(currentCell);
                if (cellBounds.contains(currentCell)) {
                    for (int i = cellBounds.x; i < cellBounds.x + cellBounds.width && i < this.fDisplayDimension.width; ++i) {
                        for (int j = cellBounds.y; j < cellBounds.y + cellBounds.height && j < this.fDisplayDimension.height; ++j) {
                            checked[i][j] = true;
                        }
                    }
                    if (this.isCellSelected(currentCell)) {
                        selectedCells.add(new Point(currentCell));
                    }
                }
                if (cellBounds.width > 0) {
                    x = cellBounds.x + cellBounds.width;
                    continue;
                }
                ++x;
            }
        }
        if (selectedCells.isEmpty()) {
            selectedCells.add(this.fModel.getElementBounds(this.getFocusPosition()).getLocation());
        }
        return selectedCells;
    }

    public String getToolTipText(MouseEvent event) {
        Point cell = this.convertPointToCell(event.getPoint());
        if (!new Rectangle(new Point(0, 0), this.fDisplayDimension).contains(cell)) {
            return null;
        }
        DisplayElement displayElement = this.getModel().getElementAt(cell);
        if (displayElement != null && this.fToolTipProvider != null) {
            return this.fToolTipProvider.getToolTipText(this, displayElement);
        }
        return super.getToolTipText(event);
    }

    public boolean isInsertMode() {
        return this.fInsertMode;
    }

    public void setInsertMode(boolean insertMode) {
        boolean fOldMode = this.fInsertMode;
        this.fInsertMode = insertMode;
        this.getModel().setInsertMode(insertMode);
        this.firePropertyChange("insertMode", fOldMode, this.fInsertMode);
    }

    protected Point getSelectionStart() {
        if (this.getStartSelection() == null || this.getEndSelection() == null) {
            return null;
        }
        Point selectionStart = new Point(Math.min(this.getStartSelection().x, this.getEndSelection().x), Math.min(this.getStartSelection().y, this.getEndSelection().y));
        return selectionStart;
    }

    public DisplayCellEditorAllocator getDisplayCellEditorAllocator() {
        return this.fDisplayCellEditorAllocator;
    }

    public void setDisplayCellEditorAllocator(DisplayCellEditorAllocator displayCellEditorAllocator) {
        this.fDisplayCellEditorAllocator = displayCellEditorAllocator;
    }

    public void selectAll() {
        this.setStartSelection(new Point(0, 0));
        this.setEndSelection(new Point(this.fDisplayDimension.width - 1, this.fDisplayDimension.height - 1));
        this.repaint();
    }

    public DisplayToolTipProvider getToolTipProvider() {
        return this.fToolTipProvider;
    }

    public void setToolTipProvider(DisplayToolTipProvider toolTipSupplier) {
        this.setToolTipText("");
        this.fToolTipProvider = toolTipSupplier;
    }

    protected void setEndSelection(Point endSelection) {
        Point oldEndSelection = this.fEndSelection;
        this.fEndSelection = endSelection;
        if (oldEndSelection == null && endSelection != null || oldEndSelection != null && !oldEndSelection.equals(endSelection)) {
            this.fireDisplaySelectionChangedEvent();
        }
    }

    protected Point getEndSelection() {
        return this.fEndSelection;
    }

    protected void setStartSelection(Point startSelection) {
        Point oldStartSelection = this.fStartSelection;
        this.fStartSelection = startSelection;
        if (oldStartSelection == null && startSelection != null || oldStartSelection != null && !oldStartSelection.equals(startSelection)) {
            this.fireDisplaySelectionChangedEvent();
        }
    }

    private void fireDisplaySelectionChangedEvent() {
        DisplaySelectionEvent displaySelectionEvent = new DisplaySelectionEvent(this, this.fStartSelection, this.fEndSelection);
        Object[] listeners = this.fEventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DisplaySelectionListener.class) continue;
            ((DisplaySelectionListener)listeners[i + 1]).displaySelectionChanged(displaySelectionEvent);
        }
    }

    protected Point getStartSelection() {
        return this.fStartSelection;
    }

    public void addDisplayFocusListener(DisplayFocusListener displayFocusListener) {
        this.fEventListeners.add(DisplayFocusListener.class, displayFocusListener);
    }

    public void addDisplayCellEditorListener(DisplayCellEditorListener displayCellEditorListener) {
        this.fEventListeners.add(DisplayCellEditorListener.class, displayCellEditorListener);
    }

    public void removeDisplayCellEditorListener(DisplayCellEditorListener displayCellEditorListener) {
        this.fEventListeners.remove(DisplayCellEditorListener.class, displayCellEditorListener);
    }

    public void removeDisplayFocusListener(DisplayFocusListener displayFocusListener) {
        this.fEventListeners.remove(DisplayFocusListener.class, displayFocusListener);
    }

    public DisplayCellEditor getCurrentCellEditor() {
        return this.fCurrentCellEditor;
    }

    public boolean isDynamicCellDimensionEnabled() {
        return this.fDynamicCellDimensionEnabled;
    }

    public void setDynamicCellDimensionEnabled(boolean dynamicCellDimensionEnabled) {
        this.fDynamicCellDimensionEnabled = dynamicCellDimensionEnabled;
    }

    public void setSimulationMode(boolean mode) {
        this.fSimulationMode = mode;
    }

    public void setOnlineTestMode(boolean mode) {
        this.fOnlineTestMode = mode;
    }

    public void setProtectionMode(boolean mode) {
        this.fProtectionMode = mode;
    }

    public boolean isNextScreen(int column) {
        if (this.fSimulationMode || this.fOnlineTestMode || !(this.fModel instanceof MessageParameterDisplayModelRTF)) {
            return false;
        }
        return column >= this.getDisplayDimension().width / 2;
    }

    private void barGraphEditor(BarDisplayElement element) {
        BarDisplaySettingPanel bdsPanel = new BarDisplaySettingPanel(true, this, element, this.getWiringDiagram());
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), bdsPanel, 11);
        bdsPanel.setDialog(dialog);
        dialog.show();
    }

    private void ioNameEditor(IONameDisplayElement element) {
        IONameSettingPanel panel = new IONameSettingPanel(this, element, this.getWiringDiagram());
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), panel, 11);
        dialog.show();
    }

    private void scaleTimeEditor(ScaleTimeDisplayElement element) {
        ScaleTimeSettingPanel panel = new ScaleTimeSettingPanel(this.getWiringDiagram(), element);
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), panel, 11);
        dialog.show();
    }

    private WiringDiagram getWiringDiagram() {
        return ((MessageParameterDisplayModelRTF)this.getModel()).fMessageParameter.getBlock().getWiringDiagram();
    }

    public void showManualEditPanel(boolean copyAction, SplittedDlg sDialog, DisplayElement insertingElemenmt, DisplayElement editingElement) {
        if (!(this.getModel() instanceof MessageParameterDisplayModelRTF) || this.getModel() instanceof MessageEditorPanel.StaticModel) {
            new LogoError(null, "dialog.logdisplay.elementOutOfBound", "Position conflict with another message text element.", 2, 0).display();
            return;
        }
        LogoError dialog = new LogoError(null, "dialog.logdisplay.conflictOccure", "Position conflict with another message text element.\n Edit manually?", 1, 1);
        if (dialog.display() == 0) {
            if (null != sDialog) {
                sDialog.close();
            }
            MessageEditorPanel editorPanel = new MessageEditorPanel((MessageParameterDisplayModelRTF)this.getModel());
            if (copyAction) {
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                editorPanel.setClipboardContent(contents);
            } else {
                editorPanel.setElementToCycleBin(insertingElemenmt);
                if (null != editingElement) {
                    editorPanel.setCellToBeRemoved(this.getFocusPosition());
                }
            }
            SplittedDlg panel = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), editorPanel, 3);
            panel.show();
            if (panel.getControlPanel().getResult() == 1) {
                this.repaint();
            }
        }
    }

    protected static class DisplayDropTarget
    implements DropTargetListener {
        private DataFlavor fDisplayItemFlavor;
        private DataFlavor fCellsFlavor;
        private LogoDisplay fLogoDisplay;

        public DisplayDropTarget(LogoDisplay logoDisplay) {
            try {
                this.fDisplayItemFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
                this.fCellsFlavor = new DataFlavor("application/x-java-logo-display-cells;class=java.util.List");
                this.fLogoDisplay = logoDisplay;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.isDataFlavorSupported(this.fDisplayItemFlavor) && !dropTargetDragEvent.isDataFlavorSupported(this.fCellsFlavor)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            dropTargetDragEvent.acceptDrag(3);
        }

        public void dragExit(DropTargetEvent dte) {
            this.fLogoDisplay.fDropRectangle = null;
            this.fLogoDisplay.repaint();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.isDataFlavorSupported(this.fDisplayItemFlavor) && !dropTargetDragEvent.isDataFlavorSupported(this.fCellsFlavor)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
            Point location = this.fLogoDisplay.convertPointToCell(dropTargetDragEvent.getLocation());
            DropTargetDropEvent dropTargetEvent = new DropTargetDropEvent(dropTargetDragEvent.getDropTargetContext(), dropTargetDragEvent.getLocation(), 0, 0);
            Transferable transferable = dropTargetEvent.getTransferable();
            Rectangle newDropRectangle = null;
            if (transferable.isDataFlavorSupported(this.fCellsFlavor)) {
                List cellList = null;
                LogoDisplay srcDisplay = null;
                try {
                    Hashtable transferData = (Hashtable)transferable.getTransferData(this.fCellsFlavor);
                    cellList = (List)transferData.get("cells");
                    srcDisplay = (LogoDisplay)transferData.get("LogoDisplay");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                Rectangle enclosingRectangle = srcDisplay.getEnclosingRectangle(cellList);
                newDropRectangle = new Rectangle(location, enclosingRectangle.getSize());
            }
            if (transferable.isDataFlavorSupported(this.fDisplayItemFlavor)) {
                DisplayElement displayElement = null;
                try {
                    displayElement = (DisplayElement)transferable.getTransferData(this.fDisplayItemFlavor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                newDropRectangle = new Rectangle(location, new Dimension(displayElement.getWidth(), displayElement.getHeight()));
            }
            newDropRectangle.setBounds(Math.min(newDropRectangle.x, this.fLogoDisplay.fDisplayDimension.width - newDropRectangle.width), Math.min(newDropRectangle.y, this.fLogoDisplay.fDisplayDimension.height - newDropRectangle.height), newDropRectangle.width, newDropRectangle.height);
            if (!newDropRectangle.equals(this.fLogoDisplay.fDropRectangle)) {
                this.fLogoDisplay.fDropRectangle = newDropRectangle;
                this.fLogoDisplay.repaint();
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.fDisplayItemFlavor)) {
                this.dropDisplayElement(transferable, dropTargetDropEvent);
            } else if (transferable.isDataFlavorSupported(this.fCellsFlavor)) {
                this.dropCellsTransferable(transferable, dropTargetDropEvent);
            }
            this.fLogoDisplay.fDropRectangle = null;
            this.fLogoDisplay.repaint();
        }

        protected void dropDisplayElement(Transferable transferable, DropTargetDropEvent dropTargetDropEvent) {
            Object transferData = null;
            try {
                transferData = transferable.getTransferData(this.fDisplayItemFlavor);
            }
            catch (Exception e) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            if (transferData instanceof DisplayElement) {
                DisplayElement displayElement = (DisplayElement)transferData;
                Point insertionCell = this.fLogoDisplay.fDropRectangle.getLocation();
                boolean inserted = this.fLogoDisplay.getModel().setElementAt(displayElement, insertionCell);
                if (!inserted) {
                    dropTargetDropEvent.rejectDrop();
                    LogoError message = new LogoError(this.fLogoDisplay, "dialog.parameter.message.insertionNotAllowed", "Insertion is not allowed on the current position.", 2);
                    message.display();
                } else {
                    this.fLogoDisplay.moveFocusTo(insertionCell, false);
                    dropTargetDropEvent.dropComplete(true);
                    this.fLogoDisplay.setFocusPosition(insertionCell);
                    this.fLogoDisplay.clearSelection();
                    this.fLogoDisplay.repaint();
                }
            }
        }

        protected void dropCellsTransferable(Transferable transferable, DropTargetDropEvent dropTargetDropEvent) {
            Object transferData = null;
            try {
                transferData = transferable.getTransferData(this.fCellsFlavor);
            }
            catch (Exception e) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Point destinationCell = null;
            if (this.fLogoDisplay.fDropRectangle == null) {
                System.out.println("Drop error");
                return;
            }
            destinationCell = this.fLogoDisplay.fDropRectangle.getLocation();
            if (transferData instanceof Hashtable) {
                LogoDisplay srcDisplay = (LogoDisplay)((Hashtable)transferData).get("LogoDisplay");
                boolean inserted = false;
                if (dropTargetDropEvent.getDropAction() == 2) {
                    List cells = (List)((Hashtable)transferData).get("cells");
                    if (srcDisplay == this.fLogoDisplay) {
                        inserted = this.fLogoDisplay.getModel().moveCells(cells, destinationCell);
                    } else if (this.fLogoDisplay.getModel() instanceof ExtenalMoveModel && srcDisplay.getModel() instanceof ExtenalMoveModel && (inserted = ((ExtenalMoveModel)this.fLogoDisplay.getModel()).moveCellsFrom((ExtenalMoveModel)srcDisplay.getModel(), cells, destinationCell))) {
                        srcDisplay.clearSelection();
                        srcDisplay.repaint();
                    }
                }
                if (dropTargetDropEvent.getDropAction() == 1 && srcDisplay == this.fLogoDisplay) {
                    System.err.println("ACTION_COPY is not supported.");
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                if (!inserted) {
                    dropTargetDropEvent.rejectDrop();
                    this.fLogoDisplay.showManualEditPanel(false, null, null, null);
                } else {
                    dropTargetDropEvent.dropComplete(true);
                    this.fLogoDisplay.setFocusPosition(destinationCell);
                    this.fLogoDisplay.clearSelection();
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            dtde.acceptDrag(3);
        }
    }

    protected class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;
        private boolean fSpecialStrategyUsed = false;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!LogoDisplay.this.isEditing() || LogoDisplay.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c instanceof JSlider) {
                    this.fSpecialStrategyUsed = true;
                }
                if (c instanceof EditableNumericSpinner || c instanceof IncrementableIntegerJTextField) {
                    this.fSpecialStrategyUsed = false;
                }
                if (c == LogoDisplay.this || this.fSpecialStrategyUsed && (c instanceof JSlider || ev.getOldValue() == null)) {
                    return;
                }
                if (!(c instanceof Window)) continue;
                if (c != SwingUtilities.getRoot(LogoDisplay.this) || LogoDisplay.this.fCurrentCellEditor.stopCellEditing()) break;
                LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
                break;
            }
        }
    }

    protected static class DisplayElementTransferHandler
    extends TransferHandler {
        private CellsTransferable clipboardTransferable;

        protected DisplayElementTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            if (c instanceof LogoDisplay) {
                return this.createTransferableFromLogoDisplay((LogoDisplay)c);
            }
            return null;
        }

        private Transferable createTransferableFromLogoDisplay(LogoDisplay logoDisplay) {
            List selectedCells = logoDisplay.getSelectedCells();
            if (selectedCells.isEmpty()) {
                selectedCells.add(logoDisplay.getFocusPosition());
            }
            return new CellsTransferable(selectedCells, logoDisplay);
        }

        public Transferable createClipboardTransferable(LogoDisplay logoDisplay) {
            List selectedCells = logoDisplay.getSelectedCells();
            List elements = logoDisplay.getModel().getCellsElements(selectedCells);
            if (this.clipboardTransferable == null) {
                this.clipboardTransferable = new CellsTransferable(selectedCells, logoDisplay);
            }
            this.clipboardTransferable.setLogoDisplay(logoDisplay);
            this.clipboardTransferable.setCells(selectedCells);
            this.clipboardTransferable.setElements(elements);
            return this.clipboardTransferable;
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }
    }

    protected class StopEditAction
    extends AbstractAction {
        protected StopEditAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (LogoDisplay.this.fCurrentCellEditor != null) {
                LogoDisplay.this.fCurrentCellEditor.stopCellEditing();
            }
        }
    }

    protected class CancelEditAction
    extends AbstractAction {
        protected CancelEditAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (LogoDisplay.this.fCurrentCellEditor != null) {
                LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
            }
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean extend;
        protected String actionName;
        protected DisplayElementTransferHandler th;

        protected NavigationalAction(int dx, int dy, boolean extend) {
            this.dx = dx;
            this.dy = dy;
            this.extend = extend;
            this.actionName = "";
        }

        protected NavigationalAction(String actionName) {
            this.actionName = actionName;
            this.th = new DisplayElementTransferHandler();
        }

        public void actionPerformed(ActionEvent e) {
            LogoDisplay logoDisplay = (LogoDisplay)e.getSource();
            if (logoDisplay.isEditing() && !logoDisplay.fCurrentCellEditor.stopCellEditing()) {
                return;
            }
            if (this.actionName.equalsIgnoreCase("escape")) {
                return;
            }
            if (this.actionName.equalsIgnoreCase("selectAll")) {
                logoDisplay.selectAll();
                return;
            }
            if (this.actionName.equalsIgnoreCase("copy")) {
                if (this.checkParameterExist(logoDisplay)) {
                    new LogoError(null, "dialog.message.parameter.notSupportCopyPaste", "Parameter doesn't support copy paste.", 2, 0).display();
                    return;
                }
                Transferable cellsTransferable = this.th.createClipboardTransferable(logoDisplay);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(cellsTransferable, null);
                return;
            }
            if (this.actionName.equalsIgnoreCase("paste")) {
                if (!logoDisplay.getModel().isCopyPasteSupported()) {
                    return;
                }
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (!logoDisplay.getModel().paste(contents, logoDisplay.getFocusPosition())) {
                    logoDisplay.showManualEditPanel(true, null, null, null);
                }
                return;
            }
            if (this.actionName.equalsIgnoreCase("insert")) {
                Point selectedCell;
                if (logoDisplay.fSimulationMode || logoDisplay.fOnlineTestMode) {
                    return;
                }
                logoDisplay.setInsertMode(!logoDisplay.isInsertMode());
                Point point = selectedCell = logoDisplay.fInsertMode ? new Point(logoDisplay.fFocusPosition) : null;
                if (logoDisplay.getStartSelection() == null || logoDisplay.getStartSelection() != null && logoDisplay.getStartSelection().equals(logoDisplay.getEndSelection())) {
                    logoDisplay.setStartSelection(selectedCell);
                    logoDisplay.setEndSelection(selectedCell);
                }
                logoDisplay.repaint();
                return;
            }
            if (this.actionName.equalsIgnoreCase("home")) {
                Point homePosition = new Point(0, logoDisplay.getFocusPosition().y);
                logoDisplay.moveFocusTo(homePosition, false);
                return;
            }
            if (this.actionName.equalsIgnoreCase("end")) {
                Point homePosition = new Point(logoDisplay.getDisplayDimension().width - 1, logoDisplay.getFocusPosition().y);
                logoDisplay.moveFocusTo(homePosition, false);
                return;
            }
            if (this.actionName.equalsIgnoreCase("enter")) {
                Point enterPosition = new Point(0, Math.min(logoDisplay.getDisplayDimension().height - 1, logoDisplay.getFocusPosition().y + 1));
                logoDisplay.moveFocusTo(enterPosition, false);
                return;
            }
            if (this.actionName.equalsIgnoreCase("delete")) {
                if (!logoDisplay.fSimulationMode && !logoDisplay.fOnlineTestMode) {
                    List selectedCells = logoDisplay.getSelectedCells();
                    if (logoDisplay.getModel() instanceof RectangleElementsDisplayModel) {
                        logoDisplay.setFocusPosition(((RectangleElementsDisplayModel)logoDisplay.getModel()).getSelectedRectangle(selectedCells).getLocation());
                    }
                    if (!logoDisplay.getModel().deleteCells(selectedCells)) {
                        logoDisplay.showManualEditPanel(false, null, null, null);
                    }
                    logoDisplay.clearSelection();
                }
                return;
            }
            if (this.actionName.equalsIgnoreCase("backspace")) {
                if (!logoDisplay.fSimulationMode && !logoDisplay.fOnlineTestMode) {
                    logoDisplay.moveFocus(-1, 0, false);
                    logoDisplay.getModel().deleteElement(logoDisplay.getFocusPosition());
                    logoDisplay.getModel().deleteElement(logoDisplay.getFocusPosition());
                }
                return;
            }
            logoDisplay.moveFocus(this.dx, this.dy, this.extend);
        }

        private boolean checkParameterExist(LogoDisplay logoDisplay) {
            List selectedCells = logoDisplay.getSelectedCells();
            Iterator cellsIterator = selectedCells.iterator();
            while (cellsIterator.hasNext()) {
                DisplayElement element = logoDisplay.getModel().getElementAt((Point)cellsIterator.next());
                if (element == null || element instanceof DefaultDisplayElement) continue;
                return true;
            }
            return false;
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean fDragNDropMode;

        protected MouseHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            Point cellLoaction;
            if (this.fDragNDropMode) {
                TransferHandler th = LogoDisplay.this.getTransferHandler();
                if (LogoDisplay.this.isEditing() && !LogoDisplay.this.fCurrentCellEditor.stopCellEditing()) {
                    LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
                }
                if (th != null && LogoDisplay.this.isDragEnabled()) {
                    th.exportAsDrag(LogoDisplay.this, e, 2);
                    return;
                }
            }
            if (!new Rectangle(new Point(0, 0), LogoDisplay.this.fDisplayDimension).contains(cellLoaction = LogoDisplay.this.convertPointToCell(e.getPoint()))) {
                return;
            }
            Point currentCell = LogoDisplay.this.fModel.getElementBounds(cellLoaction).getLocation();
            LogoDisplay.this.setEndSelection(currentCell);
            if (!currentCell.equals(LogoDisplay.this.fFocusPosition)) {
                LogoDisplay.this.setStartSelection(new Point(LogoDisplay.this.fFocusPosition));
            }
            LogoDisplay.this.repaint();
        }

        public void mousePressed(MouseEvent e) {
            Point clickedCell;
            if (!LogoDisplay.this.hasFocus()) {
                LogoDisplay.this.requestFocus();
            }
            if (!new Rectangle(new Point(0, 0), LogoDisplay.this.fDisplayDimension).contains(clickedCell = LogoDisplay.this.convertPointToCell(e.getPoint()))) {
                return;
            }
            if (e.getClickCount() < 2 && (LogoDisplay.this.fFocusPosition != null && LogoDisplay.this.fModel.getElementBounds(LogoDisplay.this.fFocusPosition).contains(clickedCell) || LogoDisplay.this.isCellSelected(clickedCell))) {
                TransferHandler th = LogoDisplay.this.getTransferHandler();
                if (th != null && LogoDisplay.this.isDragEnabled()) {
                    this.fDragNDropMode = true;
                }
                return;
            }
            this.fDragNDropMode = false;
            if (e.isShiftDown()) {
                if (LogoDisplay.this.getStartSelection() == null) {
                    LogoDisplay.this.setStartSelection(LogoDisplay.this.fFocusPosition.getLocation());
                }
                LogoDisplay.this.setEndSelection(clickedCell);
                LogoDisplay.this.setFocusPosition(LogoDisplay.this.fModel.getElementBounds(clickedCell).getLocation());
                LogoDisplay.this.repaint();
                return;
            }
            Rectangle selectArea = LogoDisplay.this.fModel.getElementBounds(clickedCell);
            LogoDisplay.this.setFocusPosition(selectArea.getLocation());
            LogoDisplay.this.setStartSelection(selectArea.getLocation());
            LogoDisplay.this.setEndSelection(new Point(selectArea.x + selectArea.width - 1, selectArea.y + selectArea.height - 1));
            if (LogoDisplay.this.isEditing() && !LogoDisplay.this.fCurrentCellEditor.stopCellEditing()) {
                LogoDisplay.this.fCurrentCellEditor.cancelCellEditing();
            }
            LogoDisplay.this.repaint();
            if (e.getClickCount() == 2 && LogoDisplay.this.getDisplayCellEditor(LogoDisplay.this.fFocusPosition) != null && LogoDisplay.this.getDisplayCellEditor(LogoDisplay.this.fFocusPosition) != LogoDisplay.this.fDefaultCellEditor) {
                LogoDisplay.this.editCellAt(LogoDisplay.this.fFocusPosition.y, LogoDisplay.this.fFocusPosition.x, e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (2 == e.getClickCount() && !LogoDisplay.this.fSimulationMode && !LogoDisplay.this.fOnlineTestMode) {
                Point clickedCell = LogoDisplay.this.convertPointToCell(e.getPoint());
                DisplayElement element = LogoDisplay.this.fModel.getElementAt(clickedCell);
                if (element instanceof BarDisplayElement) {
                    LogoDisplay.this.barGraphEditor((BarDisplayElement)element);
                }
                if (element instanceof IONameDisplayElement) {
                    LogoDisplay.this.ioNameEditor((IONameDisplayElement)element);
                }
                if (element instanceof ScaleTimeDisplayElement) {
                    LogoDisplay.this.scaleTimeEditor((ScaleTimeDisplayElement)element);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.fDragNDropMode = false;
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        public void keyTyped(KeyEvent e) {
            List selectedCells;
            if ((e.getModifiersEx() & 0x80) != 0) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            InputMap map = LogoDisplay.this.getInputMap(0);
            if (keyStroke.getKeyChar() == '\u007f') {
                return;
            }
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            map = LogoDisplay.this.getInputMap(1);
            if (map != null && map.get(keyStroke) != null) {
                return;
            }
            if (e.getKeyChar() == '\r') {
                return;
            }
            if (!LogoDisplay.this.fSimulationMode && !LogoDisplay.this.fOnlineTestMode && (selectedCells = LogoDisplay.this.getSelectedCells()).size() > 1) {
                LogoDisplay.this.setFocusPosition(LogoDisplay.this.fModel.getElementBounds(LogoDisplay.this.getSelectionStart()).getLocation());
                LogoDisplay.this.fModel.deleteCells(selectedCells);
                LogoDisplay.this.clearSelection();
            }
            Point editedCellLocation = LogoDisplay.this.fModel.getElementBounds(LogoDisplay.this.fFocusPosition).getLocation();
            if (LogoDisplay.this.fInsertMode && !LogoDisplay.this.fModel.setElementAt(LogoDisplay.this.getDefaultInsertElement(), editedCellLocation)) {
                return;
            }
            if (editedCellLocation.x != -1 && editedCellLocation.y != -1 && !LogoDisplay.this.isEditing() && !LogoDisplay.this.editCellAt(editedCellLocation.y, editedCellLocation.x, e)) {
                return;
            }
            Component editorComp = LogoDisplay.this.fCurrentEditorComp;
            if (LogoDisplay.this.isEditing() && editorComp != null && editorComp instanceof JComponent) {
                Object binding;
                JComponent component = (JComponent)editorComp;
                map = component.getInputMap(0);
                Object object = binding = map != null ? map.get(keyStroke) : null;
                if (binding == null) {
                    map = component.getInputMap(1);
                    Object object2 = binding = map != null ? map.get(keyStroke) : null;
                }
                if (binding != null) {
                    Action action;
                    ActionMap am = component.getActionMap();
                    Action action2 = action = am != null ? am.get(binding) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, e, component, e.getModifiers())) {
                        e.consume();
                    }
                } else {
                    component.dispatchEvent(e);
                }
            }
        }
    }

    protected class FocusHandler
    extends FocusAdapter {
        protected FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            LogoDisplay.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            LogoDisplay.this.repaint();
        }
    }

    public static class DisplayElementTransferable
    implements Transferable {
        private DisplayElement fDisplayElement;
        private DataFlavor fDisplayElementDataFlavor;

        public DisplayElementTransferable(DisplayElement displayElement) {
            try {
                this.fDisplayElementDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.fDisplayElement = displayElement;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!flavor.equals(this.fDisplayElementDataFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.fDisplayElement;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.fDisplayElementDataFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.fDisplayElementDataFlavor);
        }
    }

    public static class CellsTransferable
    implements Transferable {
        private Hashtable fData;
        private List fCells;
        private DataFlavor fCellListDataFlavor;

        public CellsTransferable() {
            try {
                this.fCellListDataFlavor = new DataFlavor("application/x-java-logo-display-cells;class=java.util.List");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.fData = new Hashtable();
        }

        public CellsTransferable(List cells, LogoDisplay logoDisplay) {
            try {
                this.fCellListDataFlavor = new DataFlavor("application/x-java-logo-display-cells;class=java.util.List");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.fCells = cells;
            this.fData = new Hashtable();
            this.fData.put("LogoDisplay", logoDisplay);
            this.fData.put("cells", this.fCells);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.fCellListDataFlavor)) {
                return this.fData;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.getStringData();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.fCellListDataFlavor, DataFlavor.stringFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.fCellListDataFlavor) || flavor.equals(DataFlavor.stringFlavor);
        }

        private String getStringData() {
            StringBuffer ret = new StringBuffer("");
            if (this.fData != null) {
                for (DisplayElement element : (List)this.fData.get("elements")) {
                    if (element == null) {
                        ret.append(" ");
                        continue;
                    }
                    ret.append(element.toString());
                }
            }
            return ret.toString().trim();
        }

        public void setCells(List cells) {
            this.fData.put("cells", cells);
        }

        public void setElements(List elements) {
            this.fData.put("elements", elements);
        }

        public void setLogoDisplay(LogoDisplay fLogoDisplay) {
            this.fData.put("LogoDisplay", fLogoDisplay);
        }
    }
}

